*******************************************************************************
*                        680xx Grundprogramm mendiv1                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                 Diverse Unterprogramme der Mensteuerung                    *
*******************************************************************************


getstring:                      * Liefert String in ausbuf und d0 = Anzahl Bytes
 addq.l #1,a0                   * ' berspringen
 movea.l a0,a1
getstr1:
 tst.b (a1)+                    * Bis zur Endekennung suchen
 bne.s getstr1                  * Null ist Ende
 subq.l #1,a1                   * Null nicht beachten
getstr2:
 cmp.b #' ',-(a1)
 beq.s getstr2                  * Ende-Leerzeichen ignorieren
 cmp.b #$27,(a1)
 bne carset                     * ' mu am Ende vorhanden sein
 clr.b (a1)                     * ' lschen
 lea ausbuf(a5),a2              * Ziel
 moveq #-1,d0                   * d0 ist ab jetzt Zhler der Zeichen
getstr3:
 addq.l #1,d0                   * Ein Zeichen mehr vorhanden
 move.b (a0)+,(a2)+             * Ablegen
 bne.s getstr3                  * Bis Null
 tst.l d0                       * d0 testen
 beq carset                     * Wenn Null, dann kein String vorhanden
bra carres                      * OK, String ist in Ordnung

getzahl:                        * a0 = Text / liefert Wert in d0.l
 moveq #$22,d0
 moveq #20,d1
 move #190,d2
 bsr textaus                    * Text ausgeben
getzahl1:
 lea einbuf(a5),a0
 moveq #116,d1
 move #190,d2
 moveq #29,d3
 bsr textein                    * Text einlesen
 bcs carset                     * Abbruch
 lea einbuf(a5),a0
 bsr igbn
 cmp.b #$27,(a0)                * Stringeingabe ist jetzt erlaubt
 beq.s getstring
 bsr zuweis                     * Zuweis erlaubt
 bcc.s getzahl1                 * Wenn Zuweis, dann wiederholen
bra wertmfeh                    * Wert holen mit Fehlerbehandlung

zweiwert:                       * Zwei Werte einlesen(In ausbuf steht dann Wert)
 lea txta3(pc),a0               * d0 = Lnge des Wertes/ d1 = Anzahl
 bsr.s getzahl                  * Erster Wert
 bcs carset
 lea einbuf(a5),a0              * Ziel
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #$27,(a0)
 beq carset                     * String ist nicht erlaubt
 tst.l d0                       * Wert darf nicht Null sein
 beq carset
 move.l d0,-(a7)                * Merken
 lea txta4(pc),a0
 bsr.s getzahl                  * Zweiter Wert
 movem.l (a7)+,d2               * Erster Wert zurck
 bcs carset                     * Carry = Fehler
 lea einbuf(a5),a0              * Ziel
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #$27,(a0)                * War ein String eingegeben worden ?
 beq.s zweiw1                   * Ja, dann weiter
 bsr putwert                    * Wert in ausbuf / d0 vorbereiten
zweiw1:
 move.l d2,d1                   * Anzahl der zu bearbeitenden Bytes
rts

fillspei:
 bsr zweiwert                   * Zwei Werte holen
 bcs carset                     * Fehler
fillsp0:                        * In d0 steht Lnge Wert in Bytes
 lea ausbuf(a5),a0              * In d1 steht Anzahl der zu fllenden Bytes
 clr d2                         * In ausbuf steht Wert
fillsp1:
 cmpa.l #grenze,a4              *
 bhi carset                     * Wenn grer, dann nicht weiterfllen
 move.b (a0)+,(a4)+             * Wert in Speicher
 subq.l #1,d1                   * Erniedrigen
 beq carres                     * bis alle Werte ausgegeben
 addq #1,d2                     * Nchstes Zeichen in ausbuf
 cmp d0,d2                      * Alle Zeichen durch ?
 bne.s fillsp1                  * Nein, deshalb nchstes Zeichen bertragen
bra.s fillsp0                   * Ja, deshalb von ausbuf an wiederholen

suchwert:                       * Wert suchen
 bsr.s zweiwert                 * Wie bei fillspeich
 bcs carset
 lea 1(a4),a3                   * Ab hier suchen
suchw1:
 lea ausbuf(a5),a0              * Ab hier steht Wert
 move.b (a0)+,d3
suchw2:
 cmpa.l #grenze,a3              *
 bhi carset                     * Wenn grer, dann nicht gefunden
 cmp.b (a3)+,d3                 * Erstes Byte suchen
 beq.s suchw3                   * Gefunden
 subq.l #1,d1                   * Weitersuchen
bne.s suchw2                    * OK
bra carset                      * Ende, nicht gefunden
suchw3:
 movea.l a3,a2                  * Rest vergleichen
 clr d2
suchw4:
 addq #1,d2                     * Nchstes Byte
 cmp d0,d2                      * Bis Ende des Suchwertes erreicht ist
 beq.s suchwfi                  * Dann ist Wert gefunden
 cmpm.b (a2)+,(a0)+             * So lange vergleichen, wie Werte gleich sind
 beq.s suchw4                   * Weitersuchen
bra.s suchw1                    * Von vorne beginnen
suchwfi:
 lea -1(a3),a4                  * a4 = Adresse gefunden
bra carres

putwert:                        * In d0 ist Wert
 lea ausbuf(a5),a0              * d1 ist Lnge
 cmp #1,d1                      * Ergebnis d0 = Lnge in Bytes
 bne.s putwert1
 move.b d0,(a0)                 * Byte
 moveq #1,d0                    * 1 Byte
rts
putwert1:
 cmp #2,d1
 bne.s putwert2
 move d0,(a0)                   * Wort
 moveq #2,d0                    * 2 Bytes
rts
putwert2:
 move.l d0,(a0)                 * Langwort
 moveq #4,d0                    * 4 Bytes
rts

                                                                                                                                                                                                                                                                                                                                                                 